;---------------------------------------------------------------------
;
;  file ABeep.a
;
;  This XCMD has the following syntax:
;
;   ABeep       beep once
;   ABeep ##    beep more than once!
;   ABeep ?     Show the command's parameters
;   ABeep !     Show the version and author information for the command
;
;  Created: 07-Apr-89
;  Modified:    See Mod History Below
;
;  Copyright (C) 1989-91 Apple Computer, Inc.
;  All Rights Reserved.


;---------------------------------------------------------------------
;
;  Modification History:
;
;  09-Apr-89    ADS New Today
;  08-Jun-89    ADS Converted to XCmd
;  31-Jul-89    ADS Rewrote for new interface std.
;  27-Aug-89    MLR Rewrote for seeding MPW IIgs/APW
;  21-Sep-89    MLR Added "?" and ")" Support
;  20-Mar-90    MLR Changed ")" to "!" for version info parm
;  22-Mar-90    EDS Added Interface support
;  04-Jan-91    ADS Slightly updated


            mcopy  abeep.macs
        

ABeep       START                              ; "PROC" for MPW IIgs

        longa on
        longi on
        

;  Define local stack variables
        
howMany     EQU 1       ; requested beep count
arghandle   EQU HowMany+2   ; handle to args
str     EQU argHandle+4 ; decode P string here
localSize   EQU str+127     ; how many bytes of locals

;  Define where the parameters are  


paramPtr    EQU localSize+6 ; Parameters are on top of RTL
paramSizes  EQU 4       ; & saved D register
        
        phd         ; set stack frame
        tsc 
        sec
        sbc #localSize  ; Create space for locals
        tcs         ; Set stack and
        tcd         ; D register

        lda #1      ; assuming itUs just "ABeep"
        sta <howMany
        
        lda [<paramPtr] ; 1st item is parm ct
        beq StartBeeping    ; 0 = just once

GetCount    ldy #2      ; get 1st handle
        lda [<paramPtr],y
        sta <arghandle
        iny
        iny
        lda [<paramPtr],y
        sta <arghandle+2
        
        dey         ; and push handle^
        dey
        lda [<argHandle],y
        pha
        lda [<argHandle]
        pha
        
        tdc         ; push @str
        clc
        adc #str
        pea 0
        pha
        _ZeroToPas      ; (parms^.args[1]^, numStr)
        
;  Now check the PString for the special chars - '?' or '!'

        lda <str        ; is the length 1
        and #$00FF
        cmp #1
        bne ConvertCount    ; no
        
        lda <str+1      ; yes.  What is that char?
        and #$00FF
        cmp #'?'        ; is it ?
        bne NotQuestion
        
        pea FormStr|-16       ; ? mark means give format information
        pea FormStr
        _SendCardMessage
        bra Quit
NotQuestion anop
        cmp #'!'        ; is it !
        bne ConvertCount
        
        pea VersionStr|-16  ; ! point means give version information
        pea VersionStr
        _SendCardMessage
        bra Quit

;  Convert the string to an integer - # of beeps

ConvertCount    phy         ; result space
        phy
        
        tdc         ; push @str
        clc
        adc #str
        pea 0
        pha
        _StrToNum       ; howMany := StrToNum(numStr)
        
        pla         ; only use low word
        ply
        and #15     ; and don't beep more than 15 times
        sta <howMany

;  Now we know how many times to beep.  do it!

StartBeeping    lda <howMany
        beq Quit
        
BeepLoop    _SysBeep
        
        dec <howMany
        bne BeepLoop

;  Move the RTL address back over the parameters

Quit        lda <localSize+4
        sta <localSize+4+ParamSizes
        lda <localSize+3
        sta <localSize+3+ParamSizes
        
        ldx <1+localSize    ; X has the old register
        
        tdc         ; reset the stack
        clc
        adc #2+localSize+paramSizes
        tcs

        txa         ; reset the D register
        tcd     
    
        rtl

FormStr     str    'answer "Form: ABeep {NumBeeps}"'
VersionStr  str   'answer "ABeep XCMD v1.0" & return & "Copyright (C) 1991 Apple Computer, Inc."'

        END
